/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import React, { VFC } from 'react';

import { ExternalProviderIcon } from '@client/entities/external-provider-icon';
import { ExternalAccountProviderName } from '@client/shared/api/graphql';
import { TextPromo } from '@client/shared/ui-kit';

import styles from './AccountInfo.module.css';

function getProviderText(name: ExternalAccountProviderName) {
  const TEXTS: Record<ExternalAccountProviderName, string> = {
    [ExternalAccountProviderName.Vk]: 'ВК',
    [ExternalAccountProviderName.Facebook]: 'Facebook',
    [ExternalAccountProviderName.Twitter]: 'Twitter',
    [ExternalAccountProviderName.Mailru]: 'Mail',
    [ExternalAccountProviderName.Google]: 'Google',
    [ExternalAccountProviderName.Odnoklassniki]: 'ОК',
    [ExternalAccountProviderName.Apple]: 'Apple',
    [ExternalAccountProviderName.Esia]: 'ЕСИА',
  };

  return TEXTS[name];
}

export interface AccountInfoProps {
  provider: ExternalAccountProviderName;
  displayName: string;
}

export const AccountInfo: VFC<AccountInfoProps> = (props) => {
  const { displayName, provider } = props;

  return (
    <div className={styles.root}>
      <ExternalProviderIcon size={64} name={provider} />

      <TextPromo align="center">
        <TextPromo.Title>{getProviderText(provider)}</TextPromo.Title>
        <TextPromo.Description>{displayName}</TextPromo.Description>
      </TextPromo>
    </div>
  );
};
