import { VFC, useEffect } from 'react';

import { broker } from '@client/features/bind-external-account';
import { useExternalAccountsWidgetQuery } from '@client/shared/api/graphql';
import { List } from '@client/shared/ui-kit';

import { AccountActionListItem } from '../AccountActionListItem';

export const AccountList: VFC = () => {
  const { data, error, loading, refetch } = useExternalAccountsWidgetQuery();

  useEffect(() => {
    return broker.subscribe(() => {
      refetch();
    });
  }, [refetch]);

  if (loading || error || !data) {
    return null;
  }

  const { externalAccounts } = data;

  return (
    <List>
      {externalAccounts.map((account) => {
        const { id, provider, displayName, allowAuth } = account;

        return (
          <AccountActionListItem
            key={id}
            displayName={displayName}
            provider={provider.name}
            allowAuth={allowAuth}
          />
        );
      })}
    </List>
  );
};
