import { MouseEventHandler, VFC } from 'react';

import { MoreVertical } from '@client/shared/icons';
import { ListItemView, Text } from '@client/shared/ui-kit';

import { MemberData } from '../../types';

import styles from './FamilyMember.module.css';

const memberTypes = {
  admin: 'Администратор',
  child: 'Детский аккаунт',
  member: 'Участник',
  invite: 'Участник',
};

interface FamilyMemberProps {
  data: MemberData;
  onClick: MouseEventHandler<HTMLDivElement>;
}

export const FamilyMember: VFC<FamilyMemberProps> = ({
  data: { avatar, name, type, id },
  onClick,
}) => {
  return (
    <ListItemView onClick={onClick} className={styles.item} data-id={id}>
      <ListItemView.Before alignItems="center">
        <img className={styles.avatar} src={avatar || ''} />
      </ListItemView.Before>

      <ListItemView.Content className={styles.content}>
        <div className={styles.info}>
          {name && (
            <Text variant="text-m" className={styles.name}>
              {name}
            </Text>
          )}
          <Text variant="text-s" color="secondary">
            {memberTypes[type]}
          </Text>
        </div>
      </ListItemView.Content>

      <ListItemView.After alignItems="center">
        <MoreVertical />
      </ListItemView.After>
    </ListItemView>
  );
};
