import { FamilyPayShortcut } from '@client/features/FamilyPayShortcut';
import { useFamilyShortuctsWidgetQuery } from '@client/shared/api/graphql';
import { useExternalPaths, usePassportPaths } from '@client/shared/paths';
import { Carousel, CarouselItem, Section, ShortcutSkeleton } from '@client/shared/ui-kit';

import { FamilyChildShortcut } from './ui/components/ChildShortcut';
import { FamilyInviteShortcut } from './ui/components/InviteShortcut';
import { FamilyPlusMultiShortcut } from './ui/components/PlusMultiShortcut';

const FamilyShortcutsSkeletons = () => (
  <Section>
    <Carousel>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
    </Carousel>
  </Section>
);

export const FamilyShortcuts = () => {
  const { data, error, loading } = useFamilyShortuctsWidgetQuery();
  const { kids } = usePassportPaths();
  const { plusIsActive, plusIsInactive } = useExternalPaths();

  if (loading) {
    return <FamilyShortcutsSkeletons />;
  }

  if (!data || error) {
    return null;
  }

  const { family, viewer } = data;

  const familyUser = family.pay?.userRestrictions.find(({ uid }) => uid === viewer.id);
  const isAdmin = viewer.id === family.info?.adminUid;
  const hasPay = Boolean(
    isAdmin ? family.pay?.cardInfo?.bound : familyUser?.enabled && familyUser?.hasSecurePhone,
  );
  const cardNumber = family.pay?.cardInfo?.maskedNumber.slice(-4);
  const balance = familyUser?.balance ?? 0;

  return (
    <Section>
      <Carousel>
        {isAdmin && family.members.length <= 3 && (
          <CarouselItem>
            <FamilyInviteShortcut withInvite />
          </CarouselItem>
        )}

        <CarouselItem>
          <FamilyPayShortcut
            isAdmin={isAdmin}
            hasPay={hasPay}
            cardNumber={cardNumber}
            balance={balance}
            currency={familyUser?.limitCurrency}
            unlim={familyUser?.unlim}
          />
        </CarouselItem>

        <CarouselItem>
          <FamilyPlusMultiShortcut
            isAdmin={isAdmin}
            hasMulti={viewer.hasFamilyPlus}
            href={viewer.hasFamilyPlus ? plusIsActive : plusIsInactive}
          />
        </CarouselItem>

        <CarouselItem>
          <FamilyChildShortcut href={kids} />
        </CarouselItem>

        {isAdmin && family.members.length > 3 && (
          <CarouselItem>
            <FamilyInviteShortcut />
          </CarouselItem>
        )}
      </Carousel>
    </Section>
  );
};
