import { VFC } from 'react';

import { Shortcut } from '../Shortcut';

interface FamilyInviteShortcutProps {
  withInvite?: boolean;
}

export const FamilyInviteShortcut: VFC<FamilyInviteShortcutProps> = ({ withInvite }) => {
  return (
    <Shortcut
      text={withInvite ? 'Пригласите близких' : 'Вся семья в сборе'}
      buttonText={withInvite ? 'Пригласить' : undefined}
      variant="invite"
      textBold
      withImage
    />
  );
};
