import { VFC } from 'react';

import { ShortcutLink } from '../Shortcut';

interface FamilyPlusShortcutProps {
  isAdmin?: boolean;
  hasMulti?: boolean;
  href: string;
}

type FamilyPlusShortcutType = 'member' | 'admin' | 'adminPromo';

const getFamilyPlusShortcutType = ({
  isAdmin,
  hasMulti,
}: FamilyPlusShortcutProps): FamilyPlusShortcutType => {
  if (!isAdmin) return 'member';
  if (hasMulti) return 'admin';

  return 'adminPromo';
};

const types = {
  admin: {
    text: 'Плюс Мульти активен',
    buttonText: 'Управлять',
  },
  adminPromo: {
    text: 'Плюс Мульти: фильмы и музыка для всей семьи',
    buttonText: '30 дней бесплатно',
  },
  member: {
    text: 'Что такое Плюс Мульти',
    buttonText: '',
  },
};

export const FamilyPlusMultiShortcut: VFC<FamilyPlusShortcutProps> = (props) => {
  const type = getFamilyPlusShortcutType(props);

  return (
    <ShortcutLink
      href={props.href}
      variant="plusMulti"
      text={types[type].text}
      buttonText={types[type].buttonText}
      textBold
      withImage
      size={type === 'adminPromo' ? 'l' : 's'}
    />
  );
};
