import { RouterLink } from '@client/shared/libs/router-link';
import { Shortcut as _Shortcut } from '@yandex-id/components';
import { component } from '@yandex-id/components/libs/css-modules';

import opacityLight from './_opacity/opacity-light.module.css';
import variantChild from './_variant/variant-child.module.css';
import variantInvite from './_variant/variant-invite.module.css';
import variantPay from './_variant/variant-pay.module.css';
import variantPlusMulti from './_variant/variant-plusmulti.module.css';

export const Shortcut = component(_Shortcut, {
  defaultProps: {
    variant: 'invite',
    opacity: 'full',
    size: 's',
    tall: false,
    color: null,
  },
  variants: {
    variant: {
      invite: variantInvite.root,
      pay: variantPay.root,
      plusMulti: variantPlusMulti.root,
      child: variantChild.root,
    },
    opacity: {
      light: opacityLight.root,
    },
  },
});

export const ShortcutLink = component(Shortcut, {
  defaultProps: {
    variant: 'default',
    opacity: 'full',
    size: 's',
    as: RouterLink,
    tall: false,
    color: null,
  },
});
