import { VFC } from 'react';

import { FamilyPayShortcut } from '@client/features/FamilyPayShortcut';
import { useFinanceShortcutsWidgetQuery } from '@client/shared/api/graphql';
import { Section, ShortcutSkeleton } from '@client/shared/ui-kit';
import { Carousel, CarouselItem } from '@client/shared/ui-kit';

import { FinesShortcut } from './components/FinesShortcut';
import { PayShortcut } from './components/PayShortcut';

const FinanceShortcutsSkeleton = () => (
  <Section>
    <Carousel>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
      <CarouselItem>
        <ShortcutSkeleton />
      </CarouselItem>
    </Carousel>
  </Section>
);

export const FinanceShortcuts: VFC = () => {
  const { data, error, loading: isLoading } = useFinanceShortcutsWidgetQuery();

  if (isLoading) {
    return <FinanceShortcutsSkeleton />;
  }

  if (error || !data) {
    return null;
  }

  const {
    bills: { state },
    billsDocuments,
  } = data;

  const { family, account } = data;

  const familyUser = family.pay?.userRestrictions.find(({ uid }) => uid === account.id);
  const isAdmin = account.id === family.info?.adminUid;
  const hasPay = Boolean(
    isAdmin ? family.pay?.cardInfo?.bound : familyUser?.enabled && familyUser?.hasSecurePhone,
  );
  const cardNumber = family.pay?.cardInfo?.maskedNumber.slice(-4);
  const balance = familyUser?.balance ?? 0;

  const isUnregistered = state === 'unregistered' || billsDocuments.length === 0;

  return (
    <Section>
      <Carousel>
        <CarouselItem>
          <PayShortcut />
        </CarouselItem>
        <CarouselItem>
          <FamilyPayShortcut
            isAdmin={isAdmin}
            hasPay={hasPay}
            cardNumber={cardNumber}
            balance={balance}
            currency={familyUser?.limitCurrency}
            unlim={familyUser?.unlim}
          />
        </CarouselItem>
        <CarouselItem>
          <FinesShortcut isUnregistered={isUnregistered} />
        </CarouselItem>
      </Carousel>
    </Section>
  );
};
