import React from 'react';

import { logProps } from '@client/shared/libs/metrika';
import { useIdPaths } from '@client/shared/paths';

import { Shortcut } from '../Shortcut';

export interface FinesShortcutProps {
  isUnregistered: boolean;
}

export const FinesShortcut: React.FC<FinesShortcutProps> = (props) => {
  const { isUnregistered } = props;
  const { gibdd } = useIdPaths();

  return (
    <Shortcut
      variant="fines"
      size="l"
      href={gibdd}
      text={isUnregistered ? 'Добавить ВУ и СТС' : 'Проверить штрафы'}
      buttonText={isUnregistered ? 'Добавить' : 'Проверить'}
      textBold
      withImage
      {...logProps('shortcut.fines')}
    />
  );
};
