import { RouterLink } from '@client/shared/libs/router-link';
import { Shortcut as _Shortcut } from '@yandex-id/components';
import { component } from '@yandex-id/components/libs/css-modules';

import variantFamily from './_variant/variant-family.module.css';
import variantFines from './_variant/variant-fines.module.css';
import variantPay from './_variant/variant-pay.module.css';

export const Shortcut = component(_Shortcut, {
  defaultProps: {
    as: RouterLink,
    variant: 'invite',
    opacity: 'full',
    size: 's',
    color: null,
  },
  variants: {
    variant: {
      pay: variantPay.root,
      family: variantFamily.root,
      fines: variantFines.root,
    },
  },
});
