import { useEnvContext } from '@client/shared/libs/env';
import { useExternalPaths } from '@client/shared/paths';
import { Link } from '@client/shared/ui-kit';
import { Text } from '@yandex-id/components';

import { i18n } from './i18n';

import styles from './Footer.module.css';

export const Footer = () => {
  const CURRENT_YEAR = new Date().getFullYear();
  const { language } = useEnvContext();
  const externalPaths = useExternalPaths();

  return (
    <footer className={styles.root}>
      <Link href={externalPaths.tuneCommon} size="s">
        {language.name}
      </Link>
      <Text variant="text-s" color="secondary">
        © 2001–{CURRENT_YEAR}, {i18n(`Яндекс`)}
      </Text>
    </footer>
  );
};
