import { useFuturePaymentsWidgetQuery } from '@client/shared/api/graphql';
import { Section } from '@client/shared/ui-kit';

import { FuturePaymentItemSkeleton } from './ui/FuturePaymentItemSkeleton';
import { FuturePaymentItem } from './ui/FututrePaymentItem/FuturePaymentItem';

export const FuturePayments = () => {
  const { error, data, loading: isLoading } = useFuturePaymentsWidgetQuery();

  if (isLoading) {
    return (
      <Section>
        <FuturePaymentItemSkeleton />
      </Section>
    );
  }

  if (error || !data || data.futurePayments.length === 0) {
    return null;
  }

  return (
    <Section>
      <Section.Title>Подписки и будущие платежи</Section.Title>
      <div>
        {data.futurePayments.map((payment) => (
          <FuturePaymentItem payment={payment} key={payment.id} />
        ))}
      </div>
    </Section>
  );
};
