import { useRouter } from 'next/router';
import { VFC, useCallback } from 'react';

import { NetworkStatus } from '@apollo/client';
import { useGibddDataQuery } from '@client/shared/api/graphql';
import { Section } from '@client/shared/ui-kit';

import { GibddBills } from './components/GibddBills';
import { GibddHeader } from './components/GibddHeader';
import { GibddLoader } from './components/GibddLoader';
import { GibddOnboarding } from './components/GibddOnboarding';
import { useGibddPaths } from './libs';

const GibddWidget: VFC = () => {
  const router = useRouter();
  const { gibdd, pay } = useGibddPaths();
  const { loading, data, error, refetch, networkStatus } = useGibddDataQuery({
    notifyOnNetworkStatusChange: true,
  });

  const onCompleteOnboarding = useCallback(() => {
    refetch().then(() => {
      router.push(gibdd);
    });
  }, [router, refetch, gibdd]);

  if (loading || networkStatus === NetworkStatus.refetch) {
    return <GibddLoader />;
  }

  if (!data || error) {
    return null;
  }

  const {
    bills: { state, bills },
    billsDocuments,
  } = data;

  const showOnboarding = state === 'unregistered' || billsDocuments.length === 0;

  if (showOnboarding) {
    return (
      <>
        <GibddHeader backPath={pay} />
        <GibddOnboarding onComplete={onCompleteOnboarding} />
      </>
    );
  }

  if (state === 'syncing') {
    return <GibddLoader />;
  }

  return (
    <>
      <GibddHeader withSettings backPath={pay} />
      <GibddBills bills={bills} documents={billsDocuments} />
    </>
  );
};

export const Gibdd = () => {
  return (
    <Section>
      <GibddWidget />
    </Section>
  );
};
