import { useStore } from 'effector-react';
import React, { VFC, useEffect } from 'react';

import {
  billsPay3dsCompleteSource,
  billsPay3dsCompleteType,
  billsPay3dsFrameUrl,
} from '@client/features/gibdd/constants';
import { $payment3ds, waitPayment } from '@client/features/gibdd/model';
import { BillPaymentAuth3ds } from '@client/features/gibdd/types';

import { usePostMessage } from './usePostMessage';

import styles from './GibddAuth3ds.module.css';

interface GibddAuth3dsProps {
  authData: BillPaymentAuth3ds;
  onLoad?: () => void;
  onComplete: () => void;
}

const getHttpsUrl = (url: string) => {
  if (url.startsWith('http://')) {
    return url.slice(0, 4) + 's' + url.slice(4);
  }

  return url;
};

const GibddAuth3dsContent: VFC<GibddAuth3dsProps> = ({ authData, onLoad, onComplete }) => {
  const { url, method } = authData;
  const onPostMessage = usePostMessage();

  useEffect(() => {
    return onPostMessage((message) => {
      if (
        message.source === billsPay3dsCompleteSource &&
        message.type === billsPay3dsCompleteType
      ) {
        onComplete();
      }
    });
  }, [onPostMessage, onComplete]);

  return (
    <div className={styles.root}>
      <iframe
        title="3DS"
        src={`${billsPay3dsFrameUrl()}?action=${encodeURIComponent(
          getHttpsUrl(url),
        )}&method=${method}`}
        name="frame-3ds"
        onLoad={onLoad}
        frameBorder="0"
        scrolling="auto"
        data-label="3ds--frame"
      />
    </div>
  );
};

export const GibddAuth3ds: VFC = () => {
  const authData = useStore($payment3ds);

  if (!authData) {
    return null;
  }

  return <GibddAuth3dsContent authData={authData} onComplete={waitPayment} />;
};
