import { useCallback } from 'react';

type EventMessage = Record<string, unknown>;

function tryParseJSON(value: string | object): EventMessage {
  if (window.JSON && typeof value === 'string') {
    try {
      return JSON.parse(value);
    } catch (err) {
      console.error(err);

      return {};
    }
  } else {
    return value as EventMessage;
  }
}

export const usePostMessage = () => {
  return useCallback((callback: (message: EventMessage) => void) => {
    const handler = (event: MessageEvent) => {
      callback(tryParseJSON(event.data));
    };

    window.addEventListener('message', handler);

    return () => {
      window.removeEventListener('message', handler);
    };
  }, []);
};
