import React, { FC } from 'react';

import { BillsDocumentType, GibddDataQuery } from '@client/shared/api/graphql';
import { RouterLink } from '@client/shared/libs/router-link';
import { Hint, ProgressCircle } from '@client/shared/ui-kit';
import { HINT_TEXTS, useGibddPaths } from '@client/widgets/Gibdd/libs';

import styles from './GibddBillHint.module.css';

export interface IGibddBillHint {
  documents: GibddDataQuery['billsDocuments'];
}

export const GibddBillHint: FC<IGibddBillHint> = ({ documents }) => {
  const { gibddAddDl, gibddAddVrc } = useGibddPaths();

  let isDl = false;
  let isVrc = false;

  for (const document of documents) {
    if (document.type === BillsDocumentType.DriverLicense) {
      isDl = true;
    } else if (document.type === BillsDocumentType.VehicleRegistrationCertificate) {
      isVrc = true;
    }

    if (isDl && isVrc) {
      return null;
    }
  }

  const data = isDl
    ? {
        type: BillsDocumentType.VehicleRegistrationCertificate,
        href: gibddAddVrc,
      }
    : {
        type: BillsDocumentType.DriverLicense,
        href: gibddAddDl,
      };

  return (
    <Hint
      className={styles.root}
      text={HINT_TEXTS[data.type].primary()}
      as={RouterLink}
      href={data.href}
      before={
        <ProgressCircle
          variant="default"
          formatStyle="decimal"
          size={44}
          max={2}
          value={1}
          strokeWidth={3}
        />
      }
    />
  );
};
