import Link from 'next/link';
import { VFC } from 'react';

import { ArrowLongBack, Settings } from '@client/shared/icons';
import { Button } from '@client/shared/ui-kit';

import { useGibddPaths } from '../../libs';

import styles from './GibddHeader.module.css';

interface GibddHeaderProps {
  withSettings?: boolean;
  backPath?: string;
}

export const GibddHeader: VFC<GibddHeaderProps> = ({ withSettings, backPath }) => {
  const { gibddSettings } = useGibddPaths();

  return (
    <div className={styles.root}>
      {backPath && (
        <Link href={backPath}>
          <Button variant="default" size="l">
            <ArrowLongBack />
          </Button>
        </Link>
      )}
      {withSettings && (
        <Link href={gibddSettings}>
          <Button variant="clear" size="l">
            <Settings />
          </Button>
        </Link>
      )}
    </div>
  );
};
