import { VFC, useEffect, useState } from 'react';

import { useGibddDataQuery } from '@client/shared/api/graphql';
import { Spinner, Text } from '@client/shared/ui-kit';

import { useGibddPaths } from '../../libs';
import { GibddHeader } from '../GibddHeader';
import { i18n } from './i18n';

import styles from './GibddLoader.module.css';

export const GibddLoader: VFC = () => {
  const { pay } = useGibddPaths();
  const { data, refetch } = useGibddDataQuery();

  const [isOverload, setOverload] = useState(false);

  useEffect(() => {
    const refetchTimeout = setInterval(() => {
      if (data?.bills.state === 'syncing') {
        refetch();
      }
    }, 5000);

    const timeout = setTimeout(() => {
      setOverload(true);
    }, 20000);

    return () => {
      clearTimeout(timeout);
      clearInterval(refetchTimeout);
    };
  }, [refetch, data?.bills.state]);

  return (
    <>
      <GibddHeader backPath={pay} />
      <div className={styles.root}>
        <Spinner size={40} />
        <Text variant="heading-m">{i18n('Ищем штрафы')}</Text>
        <Text variant="text-m" color="secondary">
          {isOverload
            ? i18n('Поиск затянулся. Мы пришлем уведомление, если найдем штрафы')
            : i18n('Это займет около 20 секунд')}
        </Text>
      </div>
    </>
  );
};
