/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { useStore } from 'effector-react';
import { VFC } from 'react';

import { $paymentState, resetPayment } from '@client/features/gibdd/model';
import { useBillsPaymentPolling } from '@client/features/gibdd/useBillsPaymentPolling';
import { Button, Dialog, Spinner, Text } from '@client/shared/ui-kit';

import { GibddAuth3ds } from '../GibddAuth3ds';
import CancelImage from './assets/cancel.svg';
import FailImage from './assets/fail.svg';
import SuccessImage from './assets/success.svg';
import { i18n } from './i18n';

import styles from './GibddPaymentStatus.module.css';

interface GibddPaymentStatusContentProps {
  state: string | null;
  onClose: () => void;
}

const GibddPaymentStatusContent: VFC<GibddPaymentStatusContentProps> = ({ state, onClose }) => {
  if (state === 'wait') {
    return <Spinner size={44} />;
  }

  if (state === 'fail') {
    return (
      <div className={styles.status}>
        <img className={styles.image} src={FailImage.src} />
        <Text variant="heading-l">{i18n('Оплата не прошла')}</Text>
        <Button className={styles.close} onPress={onClose} size="xl">
          Закрыть
        </Button>
      </div>
    );
  }

  if (state === 'cancel') {
    return (
      <div className={styles.status}>
        <img className={styles.image} src={CancelImage.src} />
        <Text variant="heading-l">{i18n('Оплата отменена')}</Text>
        <Button className={styles.close} onPress={onClose} size="xl">
          Закрыть
        </Button>
      </div>
    );
  }

  if (state === 'success') {
    return (
      <div className={styles.status}>
        <img className={styles.image} src={SuccessImage.src} />
        <Text variant="heading-l">{i18n('Штраф оплачен')}</Text>
        <Button className={styles.close} onPress={onClose} size="xl">
          Отлично
        </Button>
      </div>
    );
  }

  if (state === 'auth-3ds') {
    return <GibddAuth3ds />;
  }

  return null;
};

export const GibddPaymentStatus: VFC = () => {
  const state = useStore($paymentState);

  const visible = Boolean(state);

  useBillsPaymentPolling();

  return (
    <Dialog visible={visible} onClose={resetPayment}>
      <div className={styles.content}>
        <GibddPaymentStatusContent state={state} onClose={resetPayment} />
      </div>
    </Dialog>
  );
};
