import { useRouter } from 'next/router';

import { useIdPaths } from '@client/shared/paths';

export const useGibddPaths = () => {
  const { pathname } = useRouter();
  const isIframe = pathname.startsWith('/iframe/');

  const { gibdd, gibddAddDl, gibddAddVrc, gibddSettings, gibddDocument, pay, iframe } =
    useIdPaths();

  return isIframe
    ? {
        gibdd: iframe.gibdd,
        gibddAddDl: iframe.gibddAddDl,
        gibddAddVrc: iframe.gibddAddVrc,
        gibddSettings: iframe.gibddSettings,
        gibddDocument: iframe.gibddDocument,
      }
    : { gibdd, gibddAddDl, gibddAddVrc, gibddSettings, pay, gibddDocument };
};

export const GIBDD_DOCUMENTS_MASK = [
  // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
  '00 АА 000000',
  '00 00 000000',
  // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
  '00 аа 000000',
  // для возможности изменения номера с буквами в центре
  // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
  '00 А0 000000',
  // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
  '00 0А 000000',
  // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
  '00 а0 000000',
  // eslint-disable-next-line @yandex-id/i18n/no-unwrapped-strings
  '00 0а 000000',
];
