/* eslint-disable @yandex-id/i18n/no-unwrapped-strings */
import { BillsDocumentType } from '@client/shared/api/graphql';

import { i18n } from './i18n';

const ERROR_TEXTS: Record<BillsDocumentType, () => string> = {
  [BillsDocumentType.VehicleRegistrationCertificate]: () => i18n('Неверный формат СТС'),
  [BillsDocumentType.DriverLicense]: () => i18n('Неверный формат водительского удостоверения'),
};

const DOCUMENT_NAMES: Record<BillsDocumentType, () => string> = {
  [BillsDocumentType.VehicleRegistrationCertificate]: () => i18n('СТС'),
  [BillsDocumentType.DriverLicense]: () => i18n('ВУ'),
};

export const getErrorText = (type: BillsDocumentType) => ERROR_TEXTS[type]();
export const getDocumentName = (type: BillsDocumentType) => DOCUMENT_NAMES[type]();

type TextsType = {
  heading: () => string;
  label: (onBoard?: boolean) => string;
  title: () => string;
  placeholder: string;
};

export const TEXTS: Record<BillsDocumentType, TextsType> = {
  [BillsDocumentType.DriverLicense]: {
    heading: () => i18n('Добавить ВУ'),
    label: (onBoard?: boolean) =>
      onBoard ? i18n('Номер водительского удостоверения') : i18n('Номер ВУ'),
    title: () => getDocumentName(BillsDocumentType.DriverLicense),
    placeholder: '00 00 000000',
  },
  [BillsDocumentType.VehicleRegistrationCertificate]: {
    heading: () => i18n('Добавить СТС'),
    label: () => i18n('Номер СТС'),
    title: () => getDocumentName(BillsDocumentType.VehicleRegistrationCertificate),
    placeholder: '00 AA 000000',
  },
};

export type HintTextsType = {
  primary: () => string;
  // additional: () => string;
};

export const HINT_TEXTS: Record<BillsDocumentType, HintTextsType> = {
  [BillsDocumentType.DriverLicense]: {
    primary: () => 'Добавьте также ВУ, чтобы вовремя оплачивать штрафы',
    // additional: () => 'Вы добавили СТС',
  },
  [BillsDocumentType.VehicleRegistrationCertificate]: {
    primary: () => 'Добавьте также СТС, чтобы вовремя оплачивать штрафы',
    // additional: () => 'Вы добавили ВУ',
  },
};
