import { BillsDocumentType } from '@client/shared/api/graphql';
import { createForm } from '@client/shared/libs/effector-forms';

const documentNumberRGX = new RegExp(/^(\d[1-9]|[1-9]\d) ?([А-Яа-я]{2}|\d{2}) ?\d{6}$/i);

export const setGibddForm = () =>
  createForm({
    fields: {
      car: {
        init: '',
        rules: [
          {
            name: 'car',
            validator: (value) => !value || documentNumberRGX.test(value),
          },
        ],
      },
      driverLicense: {
        init: '',
        rules: [
          {
            name: 'driverLicense',
            validator: (value) => !value || documentNumberRGX.test(value),
          },
        ],
      },
    },
    validateOn: ['change', 'blur', 'submit'],
  });

export const setDocumentNumberForm = (defaultValue?: string) =>
  createForm({
    fields: {
      [BillsDocumentType.VehicleRegistrationCertificate]: {
        init: defaultValue || '',
        rules: [
          {
            name: BillsDocumentType.VehicleRegistrationCertificate,
            validator: (value) => documentNumberRGX.test(value),
          },
        ],
      },
      [BillsDocumentType.DriverLicense]: {
        init: defaultValue || '',
        rules: [
          {
            name: BillsDocumentType.DriverLicense,
            validator: (value) => documentNumberRGX.test(value),
          },
        ],
      },
    },
    validateOn: ['change', 'blur', 'submit'],
  });
