import { useRouter } from 'next/router';
import { useMemo } from 'react';

import { useHeaderQuery } from '@client/shared/api/graphql';
import { canUseDom } from '@client/shared/libs/can-use-dom';
import { useEnvContext } from '@client/shared/libs/env';
import { Navigation } from '@client/widgets/Navigation';
import { isProdLike } from '@shared/helpers/isProdLike';
import { useTheme } from '@yandex-id/design-system';

import { HeaderSuggest } from './HeaderSuggest';
import { Logo } from './Logo';
import { User } from './User';

import styles from './Header.module.css';

export const Header = () => {
  const { language, tld, yenv } = useEnvContext();
  const { loading, error, data } = useHeaderQuery();
  const { themeProps } = useTheme({});
  const router = useRouter();
  const retpath = useMemo(() => (canUseDom ? location.href : router.pathname), [router.pathname]);

  if (loading || error || !data) {
    return null;
  }

  const { viewer } = data;

  return (
    <header className={styles.root}>
      <div className={styles.logo}>
        <Logo lang={language.id} />
      </div>
      <div className={styles.navigation}>
        <div className={styles.navigationScroll}>
          <Navigation layout="horizontal" />
        </div>
      </div>
      <div className={styles.suggest}>
        <HeaderSuggest />
      </div>
      <div className={styles.user}>
        <User
          avatarId={viewer.avatarId}
          colorScheme={themeProps['data-color']}
          env={isProdLike(yenv) ? 'prod' : 'test'}
          lang={language.id}
          plus={viewer.havePlus}
          project="passport"
          retpath={retpath}
          tld={tld}
          queryParams={{ newLogo: '1' }}
          fetchMail
        />
      </div>
    </header>
  );
};
