import React, { VFC, useEffect, useState } from 'react';

import { useMatchMedia } from '@yandex-id/components/utils/hooks';
import { SearchSuggest, createApi, useSuggestList } from '@yandex-id/search-suggest';

const api = createApi({ searchUrl: '/security/api/search', suggestUrl: '/security/api/suggest' });

export const HeaderSuggest: VFC = () => {
  const list = useSuggestList(api);
  const isWideScreen = useMatchMedia('(min-width: 1024px)');

  const [isServerRender, setServerRender] = useState(true);

  useEffect(() => {
    setServerRender(false);
  }, []);

  // NOTE: Временное решение, т.к. useMatchMedia не умеет
  // работает на сервере и возникает ошибка гидрации.
  if (isServerRender) {
    return null;
  }

  return (
    <SearchSuggest
      list={list}
      layout={isWideScreen ? 'static' : 'fullscreen'}
      scale={isWideScreen ? 'medium' : 'large'}
    />
  );
};
