import { logProps } from '@client/shared/libs/metrika';
import { useIdPaths } from '@client/shared/paths';
import { Link } from '@client/shared/ui-kit';

import { LogoIcon } from './LogoIcon';

import styles from './Logo.module.css';

interface LogoProps {
  lang: string;
}

export const Logo = (props: LogoProps) => {
  const idPaths = useIdPaths();
  const lang = ['ru', 'be', 'kk', 'ky', 'uk'].includes(props.lang) ? 'ru' : 'en';

  return (
    <Link {...logProps('logo')} href={idPaths.home} className={styles.root}>
      <LogoIcon lang={lang} />
    </Link>
  );
};
