import React, { SVGAttributes, forwardRef } from 'react';

export interface LogoProps extends SVGAttributes<SVGSVGElement> {
  /**
   * Additional className for svg root
   */
  className?: string;
  /**
   * Logo width
   *
   * @default 87
   */
  width?: number;
  /**
   * Logo height
   *
   * @default 36
   */
  height?: number;
  /**
   * Logo language
   *
   * @default 'ru'
   */
  lang: 'ru' | 'en';
}

export const LogoIcon = forwardRef<SVGSVGElement, LogoProps>((props, ref) => {
  const { className, width = 87, height = 36, lang = 'ru', ...otherProps } = props;

  return (
    <svg
      width={width}
      height={height}
      viewBox={`0 0 ${width} ${height}`}
      {...otherProps}
      focusable="false"
      aria-hidden="true"
      className={className || undefined}
      ref={ref}
    >
      <path
        d="M18 0H69C78.9411 0 87 8.05888 87 18C87 27.9411 78.9411 36 69 36H18C8.05886 36 0 27.9411 0 18C0 8.05888 8.05888 0 18 0ZM18 1.59116C8.93765 1.59116 1.59116 8.93765 1.59116 18C1.59116 27.0624 8.93763 34.4088 18 34.4088H69C78.0624 34.4088 85.4088 27.0624 85.4088 18C85.4088 8.93765 78.0624 1.59116 69 1.59116H18Z"
        fill="currentColor"
      />
      <path
        d="M7.95557 17.9002C7.95557 11.8586 12.8532 6.96094 18.8948 6.96094C24.9364 6.96094 29.834 11.8586 29.834 17.9002C29.834 23.9417 24.9364 28.8394 18.8948 28.8394C12.8532 28.8394 7.95557 23.9417 7.95557 17.9002Z"
        fill="#fc3f1d"
      />
      {lang === 'ru' ? (
        <path
          d="M20.4364 24.4747H22.7218V11.3477H19.3975C16.0544 11.3477 14.2978 13.0665 14.2978 15.5974C14.2978 17.6184 15.2611 18.8084 16.9799 20.0361L13.9956 24.4747H16.4699L19.7942 19.5072L18.642 18.7328C17.2443 17.7884 16.5644 17.0518 16.5644 15.4652C16.5644 14.0675 17.5465 13.1231 19.4164 13.1231H20.4364V24.4747Z"
          fill="#fff"
        />
      ) : (
        <path
          d="M19.1916 19.0306C19.8309 20.4308 20.044 20.9179 20.044 22.5996V24.8293H17.761V21.0701L13.4538 11.7023H15.8357L19.1916 19.0306ZM22.0073 11.7023L19.2145 18.0489H21.5355L24.3359 11.7023H22.0073Z"
          fill="#fff"
        />
      )}
      <path
        fillRule="evenodd"
        d="M67.8406 25.8463V25.8563H64.6479V9.56116H69.5776C70.8728 9.56116 72.0675 9.70172 73.1519 9.98284C74.2362 10.264 75.18 10.7158 75.9932 11.3383C76.7964 11.9607 77.429 12.7941 77.8808 13.8182C78.3326 14.8523 78.5635 16.1174 78.5635 17.6133C78.5635 19.3904 78.1619 20.8965 77.3687 22.1113C76.5756 23.3262 75.4812 24.2599 74.0956 24.8924C72.7101 25.525 71.1438 25.8463 69.3969 25.8463H67.8406ZM67.8406 23.4567V11.9507H69.2965C70.4611 11.9507 71.5053 12.1214 72.4089 12.4628C73.3125 12.8041 74.0254 13.3965 74.5374 14.2198C75.0495 15.0531 75.3105 16.1676 75.3105 17.5732C75.3105 18.8784 75.0495 19.9627 74.5274 20.8362C74.0053 21.7097 73.2724 22.3623 72.3386 22.8041C71.4049 23.2459 70.3206 23.4567 69.0856 23.4567H67.8406Z"
        fill="currentColor"
      />
      <path d="M61.8366 25.8563V9.56119H58.674V25.8563H61.8366Z" fill="currentColor" />
      <path
        d="M53.2044 17.9004C53.2044 23.942 48.3067 28.8396 42.2652 28.8396C36.2236 28.8396 31.3259 23.942 31.3259 17.9004C31.3259 11.8588 36.2236 6.96118 42.2652 6.96118C41.4625 6.96118 40.6622 7.04953 39.8788 7.22463L40.3798 9.46583C36.5143 10.3261 33.6243 13.7758 33.6243 17.9004C33.6243 22.6726 37.493 26.5413 42.2652 26.5413C47.0374 26.5413 50.9061 22.6726 50.9061 17.9004L53.2044 17.9004ZM42.2652 6.96118C48.3067 6.96118 53.2044 11.8588 53.2044 17.9004C53.2044 17.0977 53.116 16.2975 52.9409 15.5141L50.6998 16.015C49.8395 12.1495 46.3899 9.25954 42.2652 9.25954H42.2652V6.96118ZM42.2651 24.3678C44.9268 24.3678 47.213 22.7598 48.2052 20.4623L46.0987 19.5439C45.4609 21.0298 43.9845 22.0704 42.2651 22.0704C40.5638 22.0704 39.1004 21.0515 38.4519 19.5907L36.3454 20.5091C37.3484 22.7816 39.6215 24.3678 42.2651 24.3678Z"
        fill="currentColor"
      />
    </svg>
  );
});
