import { VFC, useCallback, useState } from 'react';

import { Drawer } from '@client/shared/ui-kit';
import { UserBase } from '@yandex-lego/user/User';
import { Content } from '@yandex-lego/user/withUserID/Content';
import { UserIDRequiredProps } from '@yandex-lego/user/withUserID/types';
import { useUserState } from '@yandex-lego/user/withUserID/useUserState';

import styles from './TouchUser.module.css';

export const TouchUser: VFC<UserIDRequiredProps> = (props) => {
  const { avatarId, plus, env } = props;
  const state = useUserState(props);

  const [shouldPreload, setPreload] = useState(false);

  const handleOnClick = useCallback(() => {
    setPreload(true);
    state.dispatch({ type: 'TOGGLED' });
  }, [state]);

  const handleOnClose = useCallback(() => {
    state.dispatch({ type: 'CLOSED' });
  }, [state]);

  const handleOnPointerEnter = useCallback(() => {
    setPreload(true);
  }, []);

  return (
    <>
      <UserBase
        avatarId={avatarId}
        env={env}
        plus={plus}
        onClick={handleOnClick}
        onPointerEnter={handleOnPointerEnter}
      />
      <Drawer visible={state.visible} onClose={handleOnClose} className={styles.drawer}>
        <Content {...state} preload={shouldPreload} />
      </Drawer>
    </>
  );
};
