import { VFC } from 'react';

import { useDevice } from '@client/shared/hooks';
import { User as DesktopUser } from '@yandex-lego/user/desktop';
import { UserIDRequiredProps } from '@yandex-lego/user/withUserID/types';

import { TouchUser } from './TouchUser';

export const User: VFC<UserIDRequiredProps> = (props) => {
  const { isTouch } = useDevice();

  if (isTouch) {
    return <TouchUser {...props} />;
  }

  return <DesktopUser {...props} />;
};
