import { VFC, useMemo } from 'react';

import { ForbiddenExternalAuthHint } from '@client/entities/ForbiddenExternalAuthHint';
import { AuthType, useLoginWithExternalAccountsQuery } from '@client/shared/api/graphql';
import { SocialProviders } from '@client/shared/icons';
import { usePassportPaths } from '@client/shared/paths';
import { useCurrentUrl } from '@client/shared/paths';
import { List, ListItemLink, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';

export type LoginWithExternalAccountsProps = {};

export const LoginWithExternalAccounts: VFC<LoginWithExternalAccountsProps> = () => {
  const currentUrl = useCurrentUrl();
  const passportPaths = usePassportPaths();
  const { data } = useLoginWithExternalAccountsQuery();

  const href = useMemo(() => {
    const url = new URL(passportPaths.social);

    url.searchParams.set('retpath', currentUrl.href);

    return url.href;
  }, [passportPaths.social, currentUrl.href]);

  const authType = data?.account.authType || null;
  const externalAccounts = data?.externalAccounts || [];
  const totalAccounts = externalAccounts.length;
  const showHint =
    authType === AuthType.PasswordAndSms ||
    authType === AuthType.SmsOnly ||
    authType === AuthType.YandexKey;

  return (
    <Section>
      <Section.Title>{i18n('Вход внешними аккаунтами')}</Section.Title>
      <Section.Description>
        {i18n('Входите в Яндекс с помощью Вконтакте или Госуслуг')}
      </Section.Description>

      {showHint && <ForbiddenExternalAuthHint authType={authType} />}

      <List>
        <ListItemLink
          icon={<SocialProviders />}
          text={totalAccounts > 0 ? i18n('Управлять аккаунтами') : i18n('Добавить аккаунт')}
          counter={totalAccounts}
          type={totalAccounts > 0 ? 'link' : 'add'}
          href={href}
        />
      </List>
    </Section>
  );
};
