import cx from 'classnames';
import { VFC } from 'react';

import {
  CommentsOutline,
  CreditCardOutline,
  Data,
  HeartOutline,
  HelpOutline,
  IdOutline,
  ShieldOutline,
} from '@client/shared/icons';
import { useExternalPaths, useIdPaths, usePassportPaths } from '@client/shared/paths';

import { NavigationLink } from './NavigationLink';
import { NavigationSeparator } from './NavigationSeparator';
import { i18n } from './i18n';

import styles from './Navigation.module.css';

interface NavigationProps {
  layout?: 'vertical' | 'horizontal';
}

export const Navigation: VFC<NavigationProps> = (props) => {
  const { layout = 'vertical' } = props;

  const idPaths = useIdPaths();
  const passportPaths = usePassportPaths();
  const externalPaths = useExternalPaths();

  const isVerticalLayout = layout === 'vertical';
  const isHorizontalLayout = layout === 'horizontal';

  return (
    <nav
      className={cx(styles.root, {
        [styles.root_layoutVertical]: isVerticalLayout,
        [styles.root_layoutHorizontal]: isHorizontalLayout,
      })}
    >
      <ul className={styles.list}>
        <li>
          <NavigationLink href={idPaths.home} icon={<IdOutline />}>
            {i18n('Главная', { context: 'Название раздела главной страницы' })}
          </NavigationLink>
        </li>
        <li>
          <NavigationLink href={idPaths.personal} icon={<Data />}>
            {i18n('Данные', {
              context: 'Название раздела про пользовательские данные в навигации',
            })}
          </NavigationLink>
        </li>
        <li>
          <NavigationLink href={idPaths.pay} icon={<CreditCardOutline />}>
            Yandex Pay
          </NavigationLink>
        </li>
        <li>
          <NavigationLink href={passportPaths.family} icon={<HeartOutline />}>
            {i18n('Семья', { context: 'Название раздела в навигации' })}
          </NavigationLink>
        </li>
        <li>
          <NavigationLink href={idPaths.security} icon={<ShieldOutline />}>
            {i18n('Безопасность', { context: 'Название раздела в навигации' })}
          </NavigationLink>
        </li>
        {isVerticalLayout && <NavigationSeparator />}
        <li>
          <NavigationLink href={idPaths.helpdesk} icon={<CommentsOutline />}>
            {i18n('Поддержка', { context: 'Название раздела навигации про помощь пользователю' })}
          </NavigationLink>
        </li>
        <li>
          <NavigationLink href={externalPaths.supportId} icon={<HelpOutline />}>
            {i18n('Справка', { context: 'Название раздела в навигации' })}
          </NavigationLink>
        </li>
      </ul>
    </nav>
  );
};
