import cx from 'classnames';
import { useRouter } from 'next/router';
import { FC, ReactNode } from 'react';

import { RouterLink, RouterLinkProps } from '@client/shared/libs/router-link';
import { useHover } from '@use-platform/react';

import styles from './NavigationLink.module.css';

interface NavigationLinkProps extends RouterLinkProps {
  icon: ReactNode;
}

export const NavigationLink: FC<NavigationLinkProps> = (props) => {
  const { children, icon, href } = props;
  const router = useRouter();
  const isActive = router.asPath === href || (href !== '/' && router.asPath.startsWith(href));
  const { hoverProps, isHovered } = useHover({});

  return (
    <RouterLink
      href={href}
      {...hoverProps}
      className={cx(styles.root, {
        [styles.root_isActive]: isActive,
        [styles.root_isHovered]: isHovered,
      })}
      aria-current={isActive ? 'page' : undefined}
    >
      {icon}
      {children}
    </RouterLink>
  );
};
