import { VFC } from 'react';

import cactaeSource from '@client/shared/assets/cactae.png';
import { RouterLink } from '@client/shared/libs/router-link';
import { useIdPaths } from '@client/shared/paths';
import { Button, ImageIcon, Section, SectionStack, Text } from '@client/shared/ui-kit';

import { i18n } from './i18n';

import styles from './NotFound.module.css';

export const NotFound: VFC = () => {
  const idPaths = useIdPaths();

  return (
    <SectionStack className={styles.root}>
      <Section>
        <Section.Media>
          <ImageIcon src={cactaeSource} size={160} />
        </Section.Media>
        <div className={styles.content}>
          <Text variant="heading-l" weight="bold">
            {i18n('Тут ничего нет')}
          </Text>
          <Text variant="text-m-long">
            {i18n('Возможно, страница переехала или была удалена. Попробуйте найти её через поиск')}
          </Text>
        </div>
        <Button
          as={RouterLink}
          className={styles.button}
          href={idPaths.home}
          size="xl"
          variant="default"
        >
          {i18n('Вернуться на главную')}
        </Button>
      </Section>
    </SectionStack>
  );
};
