import React, { useEffect, useRef } from 'react';

import { canUseDom } from '@client/shared/libs/can-use-dom';
import { Button } from '@client/shared/ui-kit';

import { i18n } from './i18n';

import styles from './index.module.css';

type Props = {
  onHit: () => void;
};

const WITHOUT_INTERSECTION = () => !('IntersectionObserver' in window);

export const Anchor = ({ onHit }: Props) => {
  const ref = useRef<HTMLDivElement | null>(null);

  useEffect(() => {
    if (!ref.current || WITHOUT_INTERSECTION()) {
      return;
    }

    const observer = new IntersectionObserver(([entry]) => {
      if (entry.isIntersecting) {
        onHit();
      }
    });

    observer.observe(ref.current);

    return () => {
      observer.disconnect();
    };
  }, [onHit]);

  if (canUseDom && WITHOUT_INTERSECTION()) {
    return (
      <div className={styles.root}>
        <Button onPress={onHit} variant="default" size="m">
          {i18n(`Загрузить еще`)}
        </Button>
      </div>
    );
  }

  return <div ref={ref} />;
};
