import cx from 'classnames';
import React, { ReactNode } from 'react';

import styles from './Spoiler.module.css';

interface ISpoilerProps {
  summary: ReactNode;
  className?: string;
}

export const Spoiler: React.FC<ISpoilerProps> = ({ className, summary, children }) => {
  return (
    <details className={cx(styles.root, className)}>
      <summary className={styles.summary}>{summary}</summary>
      <div className={styles.content}>{children}</div>
    </details>
  );
};
