import Link from 'next/link';
import { VFC } from 'react';

import { logProps } from '@client/shared/libs/metrika';
import { useExternalPaths } from '@client/shared/paths';
import { ServiceKeyType, i18nServices } from '@client/shared/translations/services';
import { Button, PromoContent } from '@client/shared/ui-kit';

import { i18n } from './i18n';

import styles from './Empty.module.css';

const EmptyPayments: VFC = () => {
  return (
    <section className={styles.root}>
      <PromoContent>
        <PromoContent.Image>
          <div className={styles.image} />
        </PromoContent.Image>
        <PromoContent.Title>{i18n('Платежей пока нет')}</PromoContent.Title>
        <PromoContent.Description>
          {i18n(
            'Радуйте себя покупками, получайте баллы Плюса, а мы покажем это в истории платежей',
          )}
        </PromoContent.Description>
      </PromoContent>
    </section>
  );
};

interface EmptyServicePaymentsProps {
  service: string;
}

const EmptyServicePayments: VFC<EmptyServicePaymentsProps> = ({ service }) => {
  return (
    <section className={styles.root}>
      <PromoContent>
        <PromoContent.Image>
          <div className={styles.image} />
        </PromoContent.Image>
        <PromoContent.Title>{i18n('Таких платежей пока нет')}</PromoContent.Title>
        <PromoContent.Description>
          {i18n('Похоже, вы ещё не покупали на сервисе')} {service}
        </PromoContent.Description>
        <PromoContent.SecondaryButton>
          <Link href="/pay">
            <Button variant="clear" size="xl" {...logProps('finance.empty.show-all')}>
              {i18n('Показать все платежи')}
            </Button>
          </Link>
        </PromoContent.SecondaryButton>
      </PromoContent>
    </section>
  );
};

const EmptyPlusPayments: VFC = () => {
  const externalPaths = useExternalPaths();
  const plusUrl = `${externalPaths.plus}/?utm_source=yandexid&utm_medium=payment_history&utm_campaign=empty`;

  return (
    <section className={styles.root}>
      <PromoContent>
        <PromoContent.Image>
          <div className={styles.image} />
        </PromoContent.Image>
        <PromoContent.Title>{i18n('Платежей и кешбэка Плюса пока нет')}</PromoContent.Title>
        <PromoContent.Description>
          {i18n(
            'Радуйте себя покупками, получайте баллы Плюса, а мы покажем это в истории платежей',
          )}
        </PromoContent.Description>
        <PromoContent.Button className={styles.buttonContainer}>
          <Button
            className={styles.button}
            variant="action"
            size="xl"
            target="_blank"
            as="a"
            href={plusUrl}
            {...logProps('finance.empty.to-plus')}
          >
            {i18n('Перейти в Плюс')}
          </Button>
        </PromoContent.Button>
        <PromoContent.SecondaryButton>
          <Button variant="clear" size="xl">
            {i18n('Показать все платежи')}
          </Button>
        </PromoContent.SecondaryButton>
      </PromoContent>
    </section>
  );
};

const EmptyReceiptsPayments: VFC = () => {
  return (
    <section className={styles.root}>
      <PromoContent>
        <PromoContent.Image>
          <div className={styles.image} />
        </PromoContent.Image>
        <PromoContent.Title>{i18n('Чеков пока нет')}</PromoContent.Title>
        <PromoContent.Description>
          {i18n('Радуйте себя покупками, и новые платежи отобразятся в этом разделе.')}
        </PromoContent.Description>
      </PromoContent>
    </section>
  );
};

interface EmptyProps {
  alias?: string;
}

export const Empty: VFC<EmptyProps> = ({ alias }) => {
  if (alias === 'plus') {
    return <EmptyPlusPayments />;
  }

  if (alias === 'receipts') {
    return <EmptyReceiptsPayments />;
  }

  if (alias) {
    return <EmptyServicePayments service={i18nServices(alias as ServiceKeyType)} />;
  }

  return <EmptyPayments />;
};
