import cx from 'classnames';
import { VFC } from 'react';

import { PressProps, mergeProps, useHover, usePress } from '@use-platform/react';

import styles from './FilterButton.module.css';

interface FilterButtonProps extends PressProps {
  checked?: boolean;
  text: string;
  iconUrl: string;
}

export const FilterButton: VFC<FilterButtonProps> = ({ checked, iconUrl, text, ...otherProps }) => {
  const { isHovered, hoverProps } = useHover(otherProps);
  const { pressProps } = usePress(otherProps);

  return (
    <button
      className={cx(styles.root, {
        [styles.root_hovered]: isHovered,
        [styles.root_checked]: checked,
      })}
      {...mergeProps(hoverProps, pressProps)}
    >
      <div className={styles.icon} style={{ backgroundImage: `url(${iconUrl})` }} />
      {text}
    </button>
  );
};
