import cx from 'classnames';
import { VFC } from 'react';

import { Close } from '@client/shared/icons';
import { Button } from '@client/shared/ui-kit';
import { useTheme } from '@yandex-id/design-system';

import { PaymentStatus } from '../../../PaymentStatus';
import { i18n } from './i18n';

import styles from './PaymentHeader.module.css';

interface PaymentHeaderProps {
  iconUrl?: string;
  subIconUrl?: string | null;
  serviceName?: string;
  backgroundImage?: string | null;
  description?: string;
  total?: string;
  status: string;
  isPlus?: boolean;
  onClose?(): void;
}

export const PaymentHeader: VFC<PaymentHeaderProps> = ({
  iconUrl,
  subIconUrl,
  serviceName,
  backgroundImage,
  status,
  total,
  description,
  isPlus,
  onClose,
}) => {
  const { themeProps } = useTheme({ theme: 'default', colorScheme: 'dark' });

  return (
    <div
      className={cx(styles.root, { [styles.root_plus]: isPlus })}
      style={backgroundImage ? { backgroundImage: `url(${backgroundImage})` } : {}}
      {...themeProps}
    >
      <div className={styles.iconContainer}>
        <div
          className={styles.icon}
          style={iconUrl ? { backgroundImage: `url(${iconUrl})` } : {}}
        />
        {subIconUrl && (
          <div
            className={styles.subIcon}
            style={subIconUrl ? { backgroundImage: `url(${subIconUrl})` } : {}}
          />
        )}
      </div>

      <div className={styles.service}>{serviceName}</div>
      <div className={styles.description}>{description}</div>
      <div className={styles.total}>{total}</div>
      <PaymentStatus clasName={styles.status} type={status} />

      <Button
        className={styles.close}
        variant="clear"
        size="l"
        onPress={onClose}
        aria-label={i18n('Закрыть')}
      >
        <Close />
      </Button>
    </div>
  );
};
