import cx from 'classnames';
import { VFC } from 'react';

import { Skeleton } from '@client/shared/ui-kit';
import { PressProps, mergeProps, useHover, usePress } from '@use-platform/react';

import { PaymentsStatuses } from '../PaymentStatus';
import { Info } from './components/Info';
import { State } from './components/State';

import styles from './PaymentItem.module.css';

export interface PaymentItemProps extends PressProps {
  className?: string;
  iconUrl?: string;
  subIconUrl?: string;
  label: string;
  labelPrefix?: string;
  text?: string;
  textPrefix?: string;
  cash?: string;
  plus?: string;
  edadeal?: string;
  status?: PaymentsStatuses | string;
}

interface PaymentSkeleton {
  className?: string;
}

export const PaymentSkeleton: VFC<PaymentSkeleton> = ({ className }) => (
  <Skeleton className={className} width="100%" height="68">
    <rect width="100%" height="100%" rx="24" />
  </Skeleton>
);

export const PaymentItem: VFC<PaymentItemProps> = ({
  iconUrl,
  subIconUrl,
  label,
  labelPrefix,
  text,
  textPrefix,
  cash,
  plus,
  edadeal,
  status,
  className,
  ...otherProps
}) => {
  const { isHovered, hoverProps } = useHover(otherProps);
  const { pressProps } = usePress(otherProps);

  return (
    <div
      tabIndex={0}
      className={cx(
        styles.root,
        {
          [styles.root_hovered]: isHovered,
        },
        className,
      )}
      {...mergeProps(hoverProps, pressProps)}
    >
      <div className={styles.iconContainer}>
        <div
          className={styles.icon}
          style={iconUrl ? { backgroundImage: `url(${iconUrl})` } : undefined}
        />
        {subIconUrl && (
          <div
            className={styles.subIcon}
            style={subIconUrl ? { backgroundImage: `url(${subIconUrl})` } : undefined}
          />
        )}
      </div>
      <Info
        className={styles.info}
        label={label}
        labelPrefix={labelPrefix}
        text={text}
        textPrefix={textPrefix}
      />
      <State className={styles.state} cash={cash} plus={plus} edadeal={edadeal} status={status} />
    </div>
  );
};
