import cx from 'classnames';
import { VFC } from 'react';

import styles from './Info.module.css';

interface InfoProps {
  label: string;
  labelPrefix?: string;
  text?: string;
  textPrefix?: string;
  className?: string;
}

export const Info: VFC<InfoProps> = ({ text, textPrefix, label, labelPrefix, className }) => {
  return (
    <div className={cx(styles.root, className)}>
      <div className={styles.label}>{[labelPrefix, label].filter(Boolean).join(' • ')}</div>
      <div className={styles.text}>{[textPrefix, text].filter(Boolean).join(' • ')}</div>
    </div>
  );
};
