import cx from 'classnames';
import { VFC } from 'react';

import { PaymentStatus, PaymentsStatuses } from '../../../PaymentStatus/PaymentStatus';
import { PlusValue } from '../../../PlusValue/PlusValue';

import styles from './State.module.css';

interface StateProps {
  className?: string;
  cash?: string;
  plus?: string;
  edadeal?: string;
  status?: PaymentsStatuses | string;
}

const DISPLAYED_STATUSES = ['refunded', 'cancelled', 'advance'];

export const State: VFC<StateProps> = ({ cash, plus, edadeal, status, className }) => {
  let additional = (
    <>
      {edadeal && <div className={styles.edadeal}>{edadeal}</div>}
      {cash && plus && <PlusValue className={styles.plus}>{plus}</PlusValue>}
    </>
  );

  if (status && DISPLAYED_STATUSES.includes(status)) {
    additional = <PaymentStatus clasName={styles.status} type={status} />;
  }

  let main = (
    <div className={cx(styles.main, { [styles.main_refunded]: status === 'refunded' })}>{cash}</div>
  );

  if (!cash) {
    main = <PlusValue className={styles.main}>{plus}</PlusValue>;
  }

  return (
    <div className={cx(styles.root, className)}>
      {main}
      <div className={styles.additional}>{additional}</div>
    </div>
  );
};
