import cx from 'classnames';
import { ReactNode, VFC } from 'react';

import { Refund, Reject } from '@client/shared/icons';

import { i18n } from './i18n';

import styles from './PaymentStatus.module.css';

export type PaymentsStatuses = 'refunded' | 'cancelled';

const STATUSES_NAMES: Record<string, () => string> = {
  refunded: () => i18n('Возврат'),
  cancelled: () => i18n('Отмена'),
  advance: () => i18n('Авансовый'),
};

const STATUSES_ICONS: Record<string, ReactNode> = {
  refunded: <Refund className={styles.icon} />,
  cancelled: <Reject className={styles.icon} />,
};

export interface PaymentStatusProps {
  clasName?: string;
  type: PaymentsStatuses | string;
}

export const PaymentStatus: VFC<PaymentStatusProps> = ({ type, clasName }) => {
  const statusName = STATUSES_NAMES[type] && STATUSES_NAMES[type]();

  if (!statusName) {
    return null;
  }

  const icon = STATUSES_ICONS[type];

  return (
    <div className={cx(styles.root, styles[`root_${type}`], clasName)}>
      {icon}
      {statusName}
    </div>
  );
};
