import { createContext, useContext } from 'react';

import { Order } from '../../types';

interface IPaymentHistoryContext {
  paymentDetails: {
    data?: Order;
    openPopup(data: any): void;
    closePopup(): void;
  };
  paymentList: {
    setCount(count: number): void;
  };
  isShort: boolean;
}

const VOID_FUNC = () => undefined;

export const PaymentHistoryContext = createContext<IPaymentHistoryContext>({
  paymentDetails: {
    openPopup: VOID_FUNC,
    closePopup: VOID_FUNC,
  },
  paymentList: {
    setCount: VOID_FUNC,
  },
  isShort: false,
});

export const PaymentHistoryProvider = PaymentHistoryContext.Provider;

export function usePaymentHistoryContext() {
  return useContext(PaymentHistoryContext);
}
