import { ServiceKeyType, i18nServices } from '@client/shared/translations/services';

import { Order } from '../types';

export const getServiceName = (data: Order) => {
  if (data.isReceipt) {
    return data.retailerName || i18nServices('my_purchase');
  }

  if (data.source === 'yandexpay') {
    return i18nServices('pay');
  }

  return i18nServices(data.service.i18nKeyName as ServiceKeyType) || data.service.name;
};
