import React, { VFC } from 'react';

import { PublicIdListItem } from '@client/features/personal-public-id';
import { StarOutline } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { useExternalPaths } from '@client/shared/paths';
import { List, ListItemLink, Section } from '@client/shared/ui-kit';

import { i18n } from './i18n';

export const PublicData: VFC = () => {
  const externalPaths = useExternalPaths();

  return (
    <Section>
      <Section.Title anchor="public-data">
        {i18n('Публичные данные', { context: 'Заголовок блока публичные данные в ЛК' })}
      </Section.Title>
      <List>
        <ListItemLink
          icon={<StarOutline />}
          text={i18n('Ваши отзывы и оценки', {
            context: 'Текст ссылки на раздел с отзывами и оценками',
          })}
          href={externalPaths.ugcCabinet}
          target="_blank"
          {...logProps('listitem-link.user-ratings')}
        />
        <PublicIdListItem />
      </List>
    </Section>
  );
};
