import { VFC } from 'react';

import { ControlQuestionListItem } from '@client/features/account-control-question';
import { RecoveryEmailList } from '@client/features/account-recovery-email';
import { Phone } from '@client/shared/icons';
import { logProps } from '@client/shared/libs/metrika';
import { usePassportPaths } from '@client/shared/paths';
import { List, ListItemLink, ListSkeleton, Section } from '@client/shared/ui-kit';

import { RecoveryMethodsHint, RecoveryMethodsHintSkeleton } from './RecoveryMethodsHint';
import { useRecoveryMethodsData } from './api/store';
import { i18n } from './i18n';

export const RecoveryMethodsList = () => {
  const { data, isLoading, error } = useRecoveryMethodsData();
  const passportPaths = usePassportPaths();

  if (error) {
    return null;
  }

  if (isLoading || !data) {
    return (
      <>
        <RecoveryMethodsHintSkeleton />
        <ListSkeleton count={3} />
      </>
    );
  }

  const { phone } = data;
  const { quarantineEnd } = phone || {};

  return (
    <>
      <RecoveryMethodsHint {...data} />
      <List>
        <ListItemLink
          {...logProps('listitem.phone')}
          href={passportPaths.phones}
          icon={<Phone />}
          label={phone && i18n('Телефон')}
          text={phone?.number ?? i18n('Добавить телефон')}
          warning={
            // TODO: Возможно также нужно обрабатывать кейс при замене телефона
            typeof quarantineEnd === 'number' && `${quarantineEnd} ${i18n('дней до удаления')}`
          }
        />

        <ControlQuestionListItem />

        <RecoveryEmailList showAddEmail />
      </List>
    </>
  );
};

export const RecoveryMethods: VFC = () => {
  return (
    <Section>
      <Section.Title anchor="recovery-methods">{i18n('Способы восстановления')}</Section.Title>
      <Section.Description>
        {i18n('Помогут вернуть доступ к аккаунту, если что-то случится.')}
      </Section.Description>

      <RecoveryMethodsList />
    </Section>
  );
};
