import { RouterLink } from '@client/shared/libs/router-link';
import { Hint, HintProps, ProgressCircle } from '@client/shared/ui-kit';

import { RecoveryMethodsData } from '../api/store';
import { useSecurityProgress } from './hooks';

type HintVariant = HintProps['variant'];

const Link = RouterLink.bind({});

Link.defaultProps = { scroll: false };

export const RecoveryMethodsHint = (props: RecoveryMethodsData) => {
  const securityProgress = useSecurityProgress(props);
  let variant: HintVariant = 'info';

  if (securityProgress.progress === 0) {
    variant = 'negative';
  } else if (securityProgress.progress === securityProgress.total) {
    variant = 'positive';
  }

  return (
    <Hint
      text={securityProgress.hint}
      variant={variant}
      as={securityProgress.link ? Link : undefined}
      href={securityProgress.link}
      before={
        <ProgressCircle
          variant="default"
          formatStyle="decimal"
          strokeWidth={3}
          size={44}
          max={securityProgress.total}
          value={securityProgress.progress}
        />
      }
    />
  );
};
