import { MockedResponse } from '@apollo/client/testing';

import {
  EmailType,
  RecoveryMethodsDocument,
  RecoveryMethodsQuery,
} from '../../../../shared/api/graphql';

export const simpleData: ReadonlyArray<MockedResponse<RecoveryMethodsQuery>> = [
  {
    request: {
      query: RecoveryMethodsDocument,
    },
    result: {
      data: {
        account: {
          id: '4069165726',
          question: {
            id: '99',
            text: 'Just enter this',
          },
          phones: [
            {
              id: '1231231',
              number: '+1 555 777-66-55',
              isPrimary: true,
              operation: null,
            },
          ],
          emails: [
            {
              address: 'yndx-super@yandex.co.il',
              type: EmailType.Native,
              isPrimary: false,
              isConfirmed: true,
            },
            {
              address: 'yndx-super@yandex.com',
              type: EmailType.Native,
              isPrimary: true,
              isConfirmed: true,
            },
            {
              address: 'yndx-super@google.com',
              type: EmailType.External,
              isPrimary: false,
              isConfirmed: false,
            },
          ],
        },
      },
    },
  },
];
