import { EmailType, PhoneOperationType, useRecoveryMethodsQuery } from '@client/shared/api/graphql';
import { ExtractMappedQueryResult, useMappedQuery } from '@client/shared/libs/apollo';

export function useRecoveryMethodsData() {
  return useMappedQuery(useRecoveryMethodsQuery, (data) => {
    const { account } = data;
    const phone = account.phones.find((phone) => phone.isPrimary);
    const emails = account.emails.filter((email) => {
      return email.type !== EmailType.Native && !email.isPrimary;
    });
    const { operation } = phone || {};

    const hasRemoveOperation =
      operation?.type === PhoneOperationType.Remove && typeof operation?.finishedAt === 'number';
    const quarantineEnd = hasRemoveOperation
      ? Math.ceil((operation.finishedAt - Date.now()) / 1000 / 60 / 60 / 24)
      : undefined;

    return {
      phone: phone ? { ...phone, quarantineEnd } : undefined,
      emails,
      question: account.question?.text,
    };
  });
}

export type RecoveryMethodsData = ExtractMappedQueryResult<typeof useRecoveryMethodsData>;
