import React, { VFC } from 'react';

import { useExternalPaths, useIdPaths, usePassportPaths } from '@client/shared/paths';
import { Section, ShortcutLink, ShortcutSkeleton } from '@client/shared/ui-kit';
import { Carousel, CarouselItem } from '@client/shared/ui-kit';

import { useSecurityShortcutsData } from './api/store';
import { i18n } from './i18n';

export const SecurityShortcuts: VFC = () => {
  const { isLoading, data, error } = useSecurityShortcutsData();
  const idPaths = useIdPaths();
  const passportPaths = usePassportPaths();
  const externalPaths = useExternalPaths();

  if (error) {
    return null;
  }

  if (isLoading || !data) {
    const skeletonContent = Array.from({ length: 4 }, (_, index) => {
      return (
        <CarouselItem key={index}>
          <ShortcutSkeleton />
        </CarouselItem>
      );
    });

    return (
      <Section>
        <Carousel>{skeletonContent}</Carousel>
      </Section>
    );
  }

  const { phone, has2FA, question } = data;

  return (
    <Section>
      <Carousel>
        {!phone && (
          <CarouselItem>
            <ShortcutLink
              href={passportPaths.phones}
              size="l"
              buttonText={i18n('Добавить')}
              text={i18n('Добавьте номер телефона')}
              label={i18n('Усильте защиту')}
              variant="insecure"
              textBold
              withImage
              target="_blank"
            />
          </CarouselItem>
        )}
        {phone && !has2FA && (
          <CarouselItem>
            <ShortcutLink
              href={idPaths.securityEnterMethods}
              size="l"
              buttonText={i18n('Включить')}
              text={i18n('Выберите надёжный способ входа')}
              label={i18n('Усильте защиту')}
              variant="insecure"
              textBold
              withImage
            />
          </CarouselItem>
        )}
        {phone && has2FA && !question && (
          <CarouselItem>
            <ShortcutLink
              href={idPaths.securityControlQuestion}
              size="l"
              buttonText={i18n('Добавить')}
              text={i18n('Добавьте способ восстановления')}
              label={i18n('Усильте защиту')}
              variant="insecure"
              textBold
              withImage
            />
          </CarouselItem>
        )}
        <CarouselItem>
          <ShortcutLink
            href={externalPaths.howtoprotectyourid}
            size="s"
            text={i18n('Как усилить защиту данных')}
            variant="cat"
            withImage
            target="_blank"
          />
        </CarouselItem>
        <CarouselItem>
          <ShortcutLink
            href={idPaths.activity}
            size="s"
            label={i18n('Активность')}
            labelBold
            text={i18n('все события за 180 дней')}
            variant="activity"
            withImage
          />
        </CarouselItem>
        <CarouselItem>
          <ShortcutLink
            href={passportPaths.devices}
            size="s"
            label={i18n('Устройства')}
            labelBold
            text={i18n('где вы вошли в Яндекс', {
              context: 'Часть фразы «Устройства [перенос строки] где вы вошли в Яндекс» на кнопке',
            })}
            variant="devices"
            withImage
            target="_blank"
          />
        </CarouselItem>
        <CarouselItem>
          <ShortcutLink
            href={passportPaths.devices}
            size="s"
            label={i18n('Доступы')}
            labelBold
            text={i18n('сервисов к данным', {
              context: 'Часть фразы «Доступы [перенос строки] сервисов к данным» на кнопке',
            })}
            variant="access"
            withImage
            target="_blank"
          />
        </CarouselItem>
      </Carousel>
    </Section>
  );
};
