import { AuthType, useSecurityShortcutsQuery } from '@client/shared/api/graphql';
import { useMappedQuery } from '@client/shared/libs/apollo';

export function useSecurityShortcutsData() {
  return useMappedQuery(useSecurityShortcutsQuery, (data) => {
    const { authType, phones, question } = data.account;
    const has2FA = [AuthType.YandexKey, AuthType.SmsOnly, AuthType.PasswordAndSms].some(
      (type) => type === authType,
    );

    return {
      has2FA,
      phone: phones.find((phone) => phone.isPrimary),
      question: question?.text,
    };
  });
}
